package gov.va.med.mhv.usermgmt.data.repository;

import gov.va.med.mhv.usermgmt.data.model.AccessRoleAccessControl;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AccessRoleAccessControlRepository extends JpaRepository<AccessRoleAccessControl, Long> {
	
	@Query("select u from AccessRoleAccessControl u "
		     + "where u.accessRoleId in "+
		       "(select distinct upar.accessRoleId from UserProfileAccessRole upar where upar.userProfile.userName = :userName) " +
		       "or ((u.accessRole.isDefaultPatientRole = 1) and exists (select distinct up.id from UserProfile up where up.userName = :userName))")
	public List<AccessRoleAccessControl> findAccessRoleAccessControlByUserName(@Param("userName") String userName);	
	
}
